import java.util.Random;

public class Tester implements Runnable{

	public static double SQRT5 = Math.sqrt(5);
	public static double PHI   = (1+SQRT5)/2;
	
	private final int value;
	private final int loop;
	private final Random rand;
	
	public Tester(int value, int loop){
		this.value = value;
		this.loop  = loop;
		rand = new Random();
		new Thread(this).start();
	}		
	
	protected static long method1(long input){
		if(input < 2) return input;
		else return method1(input - 1) + method1(input - 2);
	}

	protected static long method2(long input){
		int i; 
		long x1 = 1;
		long x2 = 1;
		long x3 = 0;
		for(i = 2; i < input; ++i) {
		  x3 = x1 + x2;
		  x1 = x2;
		  x2 = x3;
		}
		return x3;
	}
	
	protected static long method3(long input){
		return Math.round((Math.pow((1+Math.sqrt(5)),input) - Math.pow((1-Math.sqrt(5)),input)) / (Math.pow(2,input) * Math.sqrt(5)));
	}

	protected static long method4(long input){
		return Math.round(Math.pow(PHI,input)/SQRT5);
	}

	public void run(){
//TargetProfiling.traceEvent(5000);
		for(int i = 0; i < loop; i++){
			int x = rand.nextInt(4) + 1;
			switch(x){
				case 1:
//TargetProfiling.traceEvent(1000);
					method1(value);
//TargetProfiling.traceEvent(1001);
					break;
				case 2:
//TargetProfiling.traceEvent(2000);
					method2(value);
//TargetProfiling.traceEvent(2001);
					break;
				case 3:
//TargetProfiling.traceEvent(3000);
					method3(value);
//TargetProfiling.traceEvent(3001);
					break;
				case 4:
//TargetProfiling.traceEvent(4000);
					method4(value);
//TargetProfiling.traceEvent(4001);
					break;
			}
			System.out.println("Thread " + Thread.currentThread().getName() + ", Loop " + i + ", Method " + x);
			try{
				Thread.sleep(rand.nextInt(10) * 100);	
			}catch(InterruptedException ie){}
		}	
//TargetProfiling.traceEvent(5001);
	}
	
	public static void main(String[] args) {
		for(int i = 0; i <= 10; i++)
			new Tester(20,25);
	}
}
